BuyableGpsFunctionsHandler = {}

--- Stores base game AI Settings Dialog texts so they can be re-applied later when required (when using vehicle which does have GPS configuration).
--- @param dialogTexts table @ Table containing dialog texts
function BuyableGpsFunctionsHandler.saveBaseGameAISettingsDialogTexts(dialogTexts)
    if (dialogTexts[1] ~= nil) then
        if (BuyableGpsFunctionsHandler.BASE_GAME_AI_WORKER_TEXT == nil) then
            BuyableGpsFunctionsHandler.BASE_GAME_AI_WORKER_TEXT = dialogTexts[1]
        end
    end

    if (dialogTexts[2] ~= nil) then
        if (BuyableGpsFunctionsHandler.BASE_GAME_AI_STEERING_ASSIST_TEXT == nil) then
            BuyableGpsFunctionsHandler.BASE_GAME_AI_STEERING_ASSIST_TEXT = dialogTexts[2]
        end
    end
end

--- Checks if vehicle is used for active contract (borrowed vehicle)
--- @param vehicle any @ Instance of vehicle
--- @return boolean @ "True" if its a mission vehicle, otherwise "False"
function BuyableGpsFunctionsHandler.isVehicleUsedForContractMission(vehicle)
    if (vehicle == nil) then
        return false
    end

    if vehicle.propertyState == VehiclePropertyState.MISSION then
        return true
    else
        return false
    end
end

--- Checks if vehicle has GPS module intalled
--- @param vehicle any @ Instance of vehicle
--- @return boolean @ "True" if GPS is installed, otherwise "False"
function BuyableGpsFunctionsHandler.isGpsSystemInstalled(vehicle)
    if (vehicle == nil) then
        return false
    end

    if vehicle.configurations == nil then
        return false
    end

    if BuyableGpsFunctionsHandler.isVehicleUsedForContractMission(vehicle) == true then
        return true -- we consider that every borrowed vehicle for contracts has GPS by default
    end

    local configurations = vehicle.configurations
    local configId = Utils.getNoNil(configurations["buyableGPS"], 0) -- returns currently active config ID

    if configId == 0 then -- config not found (checking, just in case)
        return false
    end

    if configId == 2 then -- 2 = GPS configuration bought
        return true
    else
        return false -- 1 = GPS configuration not bought
    end
end

function BuyableGpsFunctionsHandler.getIsAutomaticSteeringAllowed(spec_aiAutomaticSteering, superfunc)
    local isAutomaticSteeringAllowed = superfunc(spec_aiAutomaticSteering) -- ALWAYS CALL BASE GAME FUNCTION (superFunc) AND RETURN THE RESULTS FROM YOUR METHOD, EVEN IF YOU DON'T MAKE ANY MODIFICATIONS !!!

    if isAutomaticSteeringAllowed == false then -- if base game function returns false, then it's false (usually this means that currently attached implement does not support guidance steering, so there is no need to check if vehicle has GPS module or not)
        return isAutomaticSteeringAllowed -- returning base game value
    end

    if (spec_aiAutomaticSteering.rootVehicle == nil) then
        return isAutomaticSteeringAllowed -- returning base game value
    end

    local vehicle = spec_aiAutomaticSteering.rootVehicle

    if BuyableGpsFunctionsHandler.isVehicleUsedForContractMission(vehicle) == true then
        return isAutomaticSteeringAllowed -- returning base game function value (we don't want to modify automatic steering for mission / contract "borrowed "vehicles)
    end

    if BuyableGpsFunctionsHandler.isGpsSystemInstalled(vehicle) == false then
        return false
    else
        return isAutomaticSteeringAllowed; -- returning base game value
    end
end

AIAutomaticSteering.getIsAutomaticSteeringAllowed = Utils.overwrittenFunction(AIAutomaticSteering.getIsAutomaticSteeringAllowed, BuyableGpsFunctionsHandler.getIsAutomaticSteeringAllowed)

function BuyableGpsFunctionsHandler.show(aiUserSettings, fieldCourseSettings, vehicle, selectedMode, fieldX, fieldZ, callback, target)
    if (AISettingsDialog.INSTANCE == nil) then
        return;
    end

    local dialog = AISettingsDialog.INSTANCE

    if dialog.modeElement == nil then
        return
    end

    if dialog.modeElement.texts == nil then
        return
    end

    local dialogTexts = dialog.modeElement.texts

    if dialogTexts == nil then
        return
    end

    BuyableGpsFunctionsHandler.saveBaseGameAISettingsDialogTexts(dialogTexts)

    if BuyableGpsFunctionsHandler.isGpsSystemInstalled(vehicle) == true then
        dialog.modeElement:setTexts({ BuyableGpsFunctionsHandler.BASE_GAME_AI_WORKER_TEXT, BuyableGpsFunctionsHandler.BASE_GAME_AI_STEERING_ASSIST_TEXT }) -- we need to re-apply base game texts back (if they are already overwritten)
        return
    end

    dialog.modeElement:setTexts({
        BuyableGpsFunctionsHandler.BASE_GAME_AI_WORKER_TEXT,
        g_i18n.modEnvironments[BuyableGPS.MOD_NAME]:getText("BYGPS_AISETTINGS_DIALOG_NO_GPS_TEXT")
    })
end

AISettingsDialog.show = Utils.prependedFunction(AISettingsDialog.show, BuyableGpsFunctionsHandler.show)