-------------------------------------------------- Add Specialization --------------------------------------------------
local function AddSpecializationToSpecializationManager(specializationName, className, filename, customEnvironment)
    if g_specializationManager:getSpecializationByName(specializationName) == nil then
        g_specializationManager:addSpecialization(specializationName, className, Utils.getFilename(filename, BuyableGPS.MOD_SCRIPTS_DIRECTORY_PATH), customEnvironment)
    end
end

local function AddSpecializationToDriveablesVehicleTypes(specializationName)
    for vehicleTypeName, vehicleType in pairs(g_vehicleTypeManager.types) do
        if vehicleType ~= nil
            and SpecializationUtil.hasSpecialization(Drivable, vehicleType.specializations)
            and SpecializationUtil.hasSpecialization(Enterable, vehicleType.specializations)
            and SpecializationUtil.hasSpecialization(Motorized, vehicleType.specializations)
            and not SpecializationUtil.hasSpecialization(specializationName, vehicleType.specializations)
        then
            g_vehicleTypeManager:addSpecialization(vehicleTypeName, specializationName)
        end
    end
end

AddSpecializationToSpecializationManager(BuyableGPS.SPEC_NAME, BuyableGPS.SPEC_CLASS_NAME, BuyableGPS.SPEC_CLASS_FILENAME, nil);
AddSpecializationToDriveablesVehicleTypes(BuyableGPS.SPEC_NAME);
-------------------------------------------------- Add Specialization --------------------------------------------------

-------------------------------------------------- Add Configuration --------------------------------------------------
local function AddConfigurationToVehicleConfigurationManager(configurationName, configurationTitle, configurationXmlKey)
    if g_vehicleConfigurationManager.configurations[configurationName] == nil then
        g_vehicleConfigurationManager:addConfigurationType(configurationName, configurationTitle, configurationXmlKey, VehicleConfigurationItem) -- last parameter can be "VehicleConfigurationItem" or "PlaceableConfigurationItem"
    end
end

AddConfigurationToVehicleConfigurationManager(
    BuyableGPS.CONFIGURATION_NAME,
    g_i18n.modEnvironments[BuyableGPS.MOD_NAME]:getText("BYGPS_CONFIG_TITLE"),
    BuyableGPS.CONFIGURATION_XML_KEY
);
----------------------------------------------------- Add Configuration --------------------------------------------------