--Author: Kalin33
--FS22: 30.08.2023
--
--FS25: 06.08.2025

Sipma = {};

function Sipma.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Pickup, specializations)
end

function Sipma.registerEventListeners(vehicleType)
    SpecializationUtil.registerEventListener(vehicleType, "onLoad", Sipma)
	SpecializationUtil.registerEventListener(vehicleType, "onDelete", Sipma)
	SpecializationUtil.registerEventListener(vehicleType, "onUpdate", Sipma)
	SpecializationUtil.registerEventListener(vehicleType, "onRegisterActionEvents", Sipma)
	SpecializationUtil.registerEventListener(vehicleType, "actionEventTogglePickup", Sipma)
end

function Sipma.registerFunctions(vehicleType)
    SpecializationUtil.registerFunction(vehicleType, "pickupTriggerCallback", Sipma.pickupTriggerCallback)
end

function Sipma.actionEventTogglePickup(self, actionName, inputValue, callbackState, isAnalog)
    local spec = self.spec_pickup
    if self:getCanChangePickupState(spec, not spec.isLowered) then
        self:setPickupState(not spec.isLowered)
    end
end

function Sipma:onLoad(savegame)
	self.pickupTrigger = I3DUtil.indexToObject(self.components, self.xmlFile:getString("vehicle.sipma.pickupTrigger#node"));
	addTrigger(self.pickupTrigger, "pickupTriggerCallback", self);
	
	self.playerInTrigger = false
end 

function Sipma:onDelete()
    if self.pickupTrigger ~= nil then
	    removeTrigger(self.pickupTrigger)
		self.pickupTrigger = nil
	end
end

function Sipma:onUpdate(dt, isActiveForInput, isActiveForInputIgnoreSelection, isSelected)
    if self.isPlayerInSipmaTrigger then
	    self:raiseActive()
	end
end

function Sipma:onRegisterActionEvents(isActiveForInput, isActiveForInputIgnoreSelection)
    if self.isClient then
        local spec = self.spec_pickup
        self:clearActionEventsTable(spec.actionEvents)
        if isActiveForInputIgnoreSelection then
			if spec.actionEvents[InputAction.LOWER_IMPLEMENT] ~= nil then
				spec.actionEvents[InputAction.LOWER_IMPLEMENT] = nil
			end
        end
    end
end

function Sipma:pickupTriggerCallback(triggerId, otherId, onEnter, onLeave, onStay)
    local spec = self.spec_pickup

    if (onEnter or onStay) and g_localPlayer ~= nil and otherId == g_localPlayer.rootNode then
        if not self.playerInTrigger then
            spec.actionEvents = {}
            self:clearActionEventsTable(spec.actionEvents)
            local _, actionEventId = self:addActionEvent(spec.actionEvents, InputAction.LOWER_IMPLEMENT, self, Sipma.actionEventTogglePickup, false, true, false, true, nil)
            g_inputBinding:setActionEventTextPriority(actionEventId, GS_PRIO_HIGH)
           -- Sipma.updateActionEventText(self)
            self:raiseActive()
            self.playerInTrigger = true
        end
    elseif onLeave and g_localPlayer ~= nil and otherId == g_localPlayer.rootNode then
        if spec.actionEvents ~= nil then
            self:removeActionEvent(spec.actionEvents, InputAction.LOWER_IMPLEMENT)
        end
        self.playerInTrigger = false
    end
end

function Sipma:removeActionEvent(actionEventsTable, inputAction)
    if actionEventsTable[InputAction.LOWER_IMPLEMENT] ~= nil then
        g_inputBinding:removeActionEvent(actionEventsTable[InputAction.LOWER_IMPLEMENT].actionEventId)
        actionEventsTable[InputAction.LOWER_IMPLEMENT] = nil
    end
end