--Autor: Kalin33
--Data: 30.08.2023
--FS25: 06.08.2025

Sipmaa = {};

function Sipmaa.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Foldable, specializations)
end

function Sipmaa.registerEventListeners(vehicleType)
    SpecializationUtil.registerEventListener(vehicleType, "onLoad", Sipmaa)
	SpecializationUtil.registerEventListener(vehicleType, "onDelete", Sipmaa)
	SpecializationUtil.registerEventListener(vehicleType, "onUpdate", Sipmaa)
	SpecializationUtil.registerEventListener(vehicleType, "onRegisterActionEvents", Sipmaa)
end

function Sipmaa.registerFunctions(vehicleType)
    SpecializationUtil.registerFunction(vehicleType, "foldableTriggerCallback", Sipmaa.foldableTriggerCallback)
end

function Sipmaa:onLoad(savegame)
	self.foldableTrigger = I3DUtil.indexToObject(self.components, self.xmlFile:getString("vehicle.sipma.foldableTrigger#node"));
	addTrigger(self.foldableTrigger, "foldableTriggerCallback", self);
	
	self.playerInTrigger = false
end 

function Sipmaa:onDelete()
    if self.foldableTrigger ~= nil then
	    removeTrigger(self.foldableTrigger)
		self.foldableTrigger = nil
	end
	Sipmaa.removeActions(self)
end

function Sipmaa:onUpdate(dt, isActiveForInput, isActiveForInputIgnoreSelection, isSelected)
    if self.isPlayerInSipmaTrigger then
	    self:raiseActive()
	end
end

function Sipmaa:onRegisterActionEvents(isActiveForInput, isActiveForInputIgnoreSelection)
    if self.isClient then
	    local specFoldable = self.spec_foldable
		self:clearActionEventsTable(specFoldable.actionEvents)
		if isActiveForInputIgnoreSelection then
		    if specFoldable.actionEvents[specFoldable.foldInputButton] ~= nil then
			    self:removeActionEvent(specFoldable.actionEvents, specFoldable.foldInputButton);
			end
		end
	end
end

function Sipmaa:foldableTriggerCallback(triggerId, otherId, onEnter, onLeave, onStay)
    local spec = self.spec_foldable

    if (onEnter or onStay) and g_localPlayer ~= nil and otherId == g_localPlayer.rootNode then
        if not self.playerInTrigger then
            spec.actionEvents = {}
            self:clearActionEventsTable(spec.actionEvents)
            local _, actionEventId = self:addActionEvent(spec.actionEvents, spec.foldInputButton, self, Foldable.actionEventFold, false, true, false, true, nil);
            g_inputBinding:setActionEventTextPriority(actionEventId, GS_PRIO_HIGH)
            Foldable.updateActionEventFold(self)
            self:raiseActive()
            self.playerInTrigger = true
        end
    elseif onLeave and g_localPlayer ~= nil and otherId == g_localPlayer.rootNode then
        if spec.actionEvents ~= nil then
            self:removeActionEvent(spec.actionEvents, spec.foldInputButton);
        end
        self.playerInTrigger = false
    end
end

function Sipmaa.removeActions(self)
    g_inputBinding:beginActionEventsModification(Player.INPUT_CONTEXT_NAME)
	g_inputBinding:removeActionEventsByTarget(self)
	g_inputBinding:endActionEventsModification()
end