--Author: Kalin33
--Date: 06.08.2025

Sipmaunload = {};

function Sipmaunload.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Baler, specializations)
end

function Sipmaunload.registerEventListeners(vehicleType)
    SpecializationUtil.registerEventListener(vehicleType, "onLoad", Sipmaunload)
	SpecializationUtil.registerEventListener(vehicleType, "onDelete", Sipmaunload)
	SpecializationUtil.registerEventListener(vehicleType, "onUpdate", Sipmaunload)
	SpecializationUtil.registerEventListener(vehicleType, "onRegisterActionEvents", Sipmaunload)
end

function Sipmaunload.registerFunctions(vehicleType)
    SpecializationUtil.registerFunction(vehicleType, "unloadTriggerCallback", Sipmaunload.unloadTriggerCallback)
end

function Sipmaunload:onLoad(savegame)
	self.unloadTrigger = I3DUtil.indexToObject(self.components, self.xmlFile:getString("vehicle.sipma.unloadTrigger#node"));
	addTrigger(self.unloadTrigger, "unloadTriggerCallback", self);
	
	self.playerInTrigger = false
end 

function Sipmaunload:onDelete()
    if self.unloadTrigger ~= nil then
	    removeTrigger(self.unloadTrigger)
		self.unloadTrigger = nil
	end
end

function Sipmaunload:onUpdate(dt, isActiveForInput, isActiveForInputIgnoreSelection, isSelected)
    if self.isPlayerInSipmaTrigger then
	    self:raiseActive()
	end
end

function Sipmaunload:onRegisterActionEvents(isActiveForInput, isActiveForInputIgnoreSelection)
    if self.isClient then
        local spec = self.spec_baler
        self:clearActionEventsTable(spec.actionEvents)
        if isActiveForInputIgnoreSelection then
			if spec.actionEvents[InputAction.IMPLEMENT_EXTRA3] ~= nil then
				spec.actionEvents[InputAction.IMPLEMENT_EXTRA3] = nil
			end
        end
    end
end

function Sipmaunload:unloadTriggerCallback(triggerId, otherId, onEnter, onLeave, onStay)
    local spec = self.spec_baler

    if (onEnter or onStay) and g_localPlayer ~= nil and otherId == g_localPlayer.rootNode then
        if not self.playerInTrigger then
            spec.actionEvents = {}
            self:clearActionEventsTable(spec.actionEvents)
            local _, actionEventId = self:addActionEvent(spec.actionEvents, InputAction.IMPLEMENT_EXTRA3, self, Baler.actionEventUnloading, false, true, false, true, nil)
            g_inputBinding:setActionEventTextPriority(actionEventId, GS_PRIO_HIGH)
            --Sipma.updateActionEventText(self)
            self:raiseActive()
            self.playerInTrigger = true
        end
    elseif onLeave and g_localPlayer ~= nil and otherId == g_localPlayer.rootNode then
        if spec.actionEvents ~= nil then
            self:removeActionEvent(spec.actionEvents, InputAction.IMPLEMENT_EXTRA3)
        end
        self.playerInTrigger = false
    end
end

function Sipmaunload:removeActionEvent(actionEventsTable, inputAction)
    if actionEventsTable[InputAction.IMPLEMENT_EXTRA3] ~= nil then
        g_inputBinding:removeActionEvent(actionEventsTable[InputAction.IMPLEMENT_EXTRA3].actionEventId)
        actionEventsTable[InputAction.IMPLEMENT_EXTRA3] = nil
    end
end