--[[
Copyright (C) GtX (Andy), 2022

Author: GtX | Andy
Date: 11.05.2022
Revision: FS25-01

Contact:
https://forum.giants-software.com
https://github.com/GtX-Andy

Important:
Not to be added to any mods / maps or modified from its current release form.
No modifications may be made to this script, including conversion to other game versions without written permission from GtX | Andy
Copying or removing any part of this code for external use without written permission from GtX | Andy is prohibited.

Darf nicht zu Mods / Maps hinzugefügt oder von der aktuellen Release-Form geändert werden.
Ohne schriftliche Genehmigung von GtX | Andy dürfen keine Änderungen an diesem Skript vorgenommen werden, einschließlich der Konvertierung in andere Spielversionen
Das Kopieren oder Entfernen irgendeines Teils dieses Codes zur externen Verwendung ohne schriftliche Genehmigung von GtX | Andy ist verboten.
]]


PlaceableWorkshopTransferOwnershipPoint = {}

PlaceableWorkshopTransferOwnershipPoint.MOD_NAME = g_currentModName
PlaceableWorkshopTransferOwnershipPoint.SPEC_NAME = string.format("%s.workshopTransferOwnershipPoint", g_currentModName)
PlaceableWorkshopTransferOwnershipPoint.SPEC = string.format("spec_%s", PlaceableWorkshopTransferOwnershipPoint.SPEC_NAME)

local specEntryName = PlaceableWorkshopTransferOwnershipPoint.SPEC

function PlaceableWorkshopTransferOwnershipPoint.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(PlaceableWorkshop, specializations)
end

function PlaceableWorkshopTransferOwnershipPoint.registerEventListeners(placeableType)
    SpecializationUtil.registerEventListener(placeableType, "onPostLoad", PlaceableWorkshopTransferOwnershipPoint)
    SpecializationUtil.registerEventListener(placeableType, "onFinalizePlacement", PlaceableWorkshopTransferOwnershipPoint)
    SpecializationUtil.registerEventListener(placeableType, "onDelete", PlaceableWorkshopTransferOwnershipPoint)
end

function PlaceableWorkshopTransferOwnershipPoint.registerFunctions(placeableType)
    SpecializationUtil.registerFunction(placeableType, "getTransferOwnershipPoint", PlaceableWorkshopTransferOwnershipPoint.getTransferOwnershipPoint)
end

function PlaceableWorkshopTransferOwnershipPoint.registerXMLPaths(schema, basePath)
    schema:setXMLSpecializationType("TransferOwnershipPoint")
    TransferOwnershipPoint.registerXMLPaths(schema, basePath)
    schema:setXMLSpecializationType()
end

function PlaceableWorkshopTransferOwnershipPoint:onPostLoad()
    local sellingPoint = self.spec_workshop.sellingPoint

    if sellingPoint ~= nil then
        local spec = self[specEntryName]
        local transferPoint = TransferOwnershipPoint.new()

        transferPoint.isSellingPoint = true
        transferPoint.owningPlaceable = self
        transferPoint.baseDirectory = self.baseDirectory
        transferPoint.customEnvironment = self.customEnvironment

        -- Clone trigger and make sure the correct flags are set
        transferPoint.objectsTriggerNode = clone(sellingPoint.sellTriggerNode, true, false, true)
        CollisionFlag.setMaskFlag(transferPoint.objectsTriggerNode, CollisionFlag.VEHICLE)
        CollisionFlag.setMaskFlag(transferPoint.objectsTriggerNode, CollisionFlag.DYNAMIC_OBJECT)

        -- Replace the activatable with a shared version
        g_currentMission.activatableObjectsSystem:removeActivatable(sellingPoint.activatable)
        sellingPoint.activatable = WorkshopTransferOwnershipPointActivatable.new(sellingPoint, sellingPoint.ownWorkshop, transferPoint)

        spec.transferPoint = transferPoint
    end
end

function PlaceableWorkshopTransferOwnershipPoint:onFinalizePlacement()
    local spec = self[specEntryName]

    if spec.transferPoint ~= nil then
        spec.transferPoint:finalizePlacement()
    end
end

function PlaceableWorkshopTransferOwnershipPoint:onDelete()
    local spec = self[specEntryName]

    if spec.transferPoint ~= nil then
        spec.transferPoint:delete()
        spec.transferPoint = nil
    end
end

function PlaceableWorkshopTransferOwnershipPoint:getTransferOwnershipPoint()
    return self[specEntryName].transferPoint
end


WorkshopTransferOwnershipPointActivatable = {}
local WorkshopTransferOwnershipPointActivatable_mt = Class(WorkshopTransferOwnershipPointActivatable, VehicleSellingPointActivatable)

function WorkshopTransferOwnershipPointActivatable.new(sellingPoint, ownWorkshop, transferPoint)
    local self = setmetatable({}, WorkshopTransferOwnershipPointActivatable_mt)

    self.sellingPoint = sellingPoint

    if ownWorkshop then
        self.activateText = g_i18n:getText("action_openWorkshopOptions")
    else
        self.activateText = g_i18n:getText("action_openDealerOptions")
    end

    self.transferPoint = transferPoint
    self.transferOwnershipText = TransferOwnershipScreen.getDefaultHeaderText()

    self.activateActionEventId = nil
    self.transferObjectsActionEventId = nil

    return self
end

function WorkshopTransferOwnershipPointActivatable:registerCustomInput(inputContext)
    local _, actionEventId = g_inputBinding:registerActionEvent(InputAction.ACTIVATE_OBJECT, self, self.actionEventActivate, false, true, false, true)

    g_inputBinding:setActionEventText(actionEventId, self.activateText)
    g_inputBinding:setActionEventTextPriority(actionEventId, GS_PRIO_VERY_HIGH)
    g_inputBinding:setActionEventTextVisibility(actionEventId, true)

    self.activateActionEventId = actionEventId

    if self.transferPoint ~= nil and self.transferPoint.isEnabled then
        if inputContext == PlayerInputComponent.INPUT_CONTEXT_NAME then
            _, actionEventId = g_inputBinding:registerActionEvent(InputAction.TRANSFER_OBJECTS, self, self.actionEventTransferObjects, false, true, false, true)

            g_inputBinding:setActionEventText(actionEventId, self.transferOwnershipText)
            g_inputBinding:setActionEventTextPriority(actionEventId, GS_PRIO_VERY_HIGH)
            g_inputBinding:setActionEventTextVisibility(actionEventId, true)

            self.transferObjectsActionEventId = actionEventId
        end
    end
end

function WorkshopTransferOwnershipPointActivatable:removeCustomInput(inputContext)
    g_inputBinding:removeActionEventsByTarget(self)

    self.activateActionEventId = nil
    self.transferObjectsActionEventId = nil
end

function WorkshopTransferOwnershipPointActivatable:actionEventActivate(actionName, inputValue, callbackState, isAnalog)
    self:run()
end

function WorkshopTransferOwnershipPointActivatable:actionEventTransferObjects(actionName, inputValue, callbackState, isAnalog)
    if self.transferPoint ~= nil and self.transferPoint.isEnabled then
        self.transferPoint:openMenu()
    end
end
